/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.domain;

import eu.europa.ec.taxud.cesop.domain.ValidationErrorTypeEnum;
import eu.europa.ec.taxud.cesop.domain.ValidationResultTypeEnum;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;

public class ValidationError
implements Serializable {
    private static final long serialVersionUID = -6011003280346460581L;
    private final ValidationErrorTypeEnum errorType;
    private String messageRefId;
    private Integer errorCounter = 1;
    private String errorShortDesc;
    private String errorLongDesc;
    private String docRefId;
    private String transactionIdentifier;

    public ValidationError(ValidationErrorTypeEnum errorType) {
        this.errorType = Objects.requireNonNull(errorType);
        this.setErrorShortDesc(errorType.getDescription());
        this.setErrorLongDesc(errorType.getDescription());
    }

    public String getErrorCode() {
        return this.errorType.getCode();
    }

    public boolean isFullRejection() {
        return this.errorType.getResultType() == ValidationResultTypeEnum.FULLY_REJECTED;
    }

    @Generated
    public ValidationErrorTypeEnum getErrorType() {
        return this.errorType;
    }

    @Generated
    public String getMessageRefId() {
        return this.messageRefId;
    }

    @Generated
    public Integer getErrorCounter() {
        return this.errorCounter;
    }

    @Generated
    public String getErrorShortDesc() {
        return this.errorShortDesc;
    }

    @Generated
    public String getErrorLongDesc() {
        return this.errorLongDesc;
    }

    @Generated
    public String getDocRefId() {
        return this.docRefId;
    }

    @Generated
    public String getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    @Generated
    public void setMessageRefId(String messageRefId) {
        this.messageRefId = messageRefId;
    }

    @Generated
    public void setErrorCounter(Integer errorCounter) {
        this.errorCounter = errorCounter;
    }

    @Generated
    public void setErrorShortDesc(String errorShortDesc) {
        this.errorShortDesc = errorShortDesc;
    }

    @Generated
    public void setErrorLongDesc(String errorLongDesc) {
        this.errorLongDesc = errorLongDesc;
    }

    @Generated
    public void setDocRefId(String docRefId) {
        this.docRefId = docRefId;
    }

    @Generated
    public void setTransactionIdentifier(String transactionIdentifier) {
        this.transactionIdentifier = transactionIdentifier;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationError)) {
            return false;
        }
        ValidationError other = (ValidationError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$errorCounter = this.getErrorCounter();
        Integer other$errorCounter = other.getErrorCounter();
        if (this$errorCounter == null ? other$errorCounter != null : !((Object)this$errorCounter).equals(other$errorCounter)) {
            return false;
        }
        ValidationErrorTypeEnum this$errorType = this.getErrorType();
        ValidationErrorTypeEnum other$errorType = other.getErrorType();
        if (this$errorType == null ? other$errorType != null : !((Object)((Object)this$errorType)).equals((Object)other$errorType)) {
            return false;
        }
        String this$messageRefId = this.getMessageRefId();
        String other$messageRefId = other.getMessageRefId();
        if (this$messageRefId == null ? other$messageRefId != null : !this$messageRefId.equals(other$messageRefId)) {
            return false;
        }
        String this$errorShortDesc = this.getErrorShortDesc();
        String other$errorShortDesc = other.getErrorShortDesc();
        if (this$errorShortDesc == null ? other$errorShortDesc != null : !this$errorShortDesc.equals(other$errorShortDesc)) {
            return false;
        }
        String this$errorLongDesc = this.getErrorLongDesc();
        String other$errorLongDesc = other.getErrorLongDesc();
        if (this$errorLongDesc == null ? other$errorLongDesc != null : !this$errorLongDesc.equals(other$errorLongDesc)) {
            return false;
        }
        String this$docRefId = this.getDocRefId();
        String other$docRefId = other.getDocRefId();
        if (this$docRefId == null ? other$docRefId != null : !this$docRefId.equals(other$docRefId)) {
            return false;
        }
        String this$transactionIdentifier = this.getTransactionIdentifier();
        String other$transactionIdentifier = other.getTransactionIdentifier();
        return !(this$transactionIdentifier == null ? other$transactionIdentifier != null : !this$transactionIdentifier.equals(other$transactionIdentifier));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValidationError;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $errorCounter = this.getErrorCounter();
        result = result * 59 + ($errorCounter == null ? 43 : ((Object)$errorCounter).hashCode());
        ValidationErrorTypeEnum $errorType = this.getErrorType();
        result = result * 59 + ($errorType == null ? 43 : ((Object)((Object)$errorType)).hashCode());
        String $messageRefId = this.getMessageRefId();
        result = result * 59 + ($messageRefId == null ? 43 : $messageRefId.hashCode());
        String $errorShortDesc = this.getErrorShortDesc();
        result = result * 59 + ($errorShortDesc == null ? 43 : $errorShortDesc.hashCode());
        String $errorLongDesc = this.getErrorLongDesc();
        result = result * 59 + ($errorLongDesc == null ? 43 : $errorLongDesc.hashCode());
        String $docRefId = this.getDocRefId();
        result = result * 59 + ($docRefId == null ? 43 : $docRefId.hashCode());
        String $transactionIdentifier = this.getTransactionIdentifier();
        result = result * 59 + ($transactionIdentifier == null ? 43 : $transactionIdentifier.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ValidationError(errorType=" + (Object)((Object)this.getErrorType()) + ", messageRefId=" + this.getMessageRefId() + ", errorCounter=" + this.getErrorCounter() + ", errorShortDesc=" + this.getErrorShortDesc() + ", errorLongDesc=" + this.getErrorLongDesc() + ", docRefId=" + this.getDocRefId() + ", transactionIdentifier=" + this.getTransactionIdentifier() + ")";
    }
}

